package gov.va.med.mhv.admin.web.util;

import static gov.va.med.mhv.admin.enums.PatientCorrelationStatus.CORRELATED;
import static gov.va.med.mhv.admin.enums.PatientCorrelationStatus.CORRELATIONINVALID;
import static gov.va.med.mhv.admin.enums.PatientCorrelationStatus.FAILEDCORRELATION;
import static gov.va.med.mhv.admin.enums.PatientCorrelationStatus.FAILEDUNCORRELATION;
import static gov.va.med.mhv.admin.enums.PatientCorrelationStatus.MVIDATAMATCH;
import static gov.va.med.mhv.admin.enums.PatientCorrelationStatus.PENDINGCORRELATION;
import static gov.va.med.mhv.admin.enums.PatientCorrelationStatus.PENDINGUNCORRELATION;
import static gov.va.med.mhv.admin.enums.PatientCorrelationStatus.UNCORRELATED;

import gov.va.med.mhv.admin.util.Precondition;
import gov.va.med.mhv.common.api.dto.PatientDTO;

public final class PatientCorrelationStatusUtils {

	public static boolean isUncorrelated(PatientDTO patient) {
		Precondition.assertNotNull("patient", patient);
		return UNCORRELATED.equals(patient.getCorrelationStatus());
	}

	public static boolean isCorrelated(PatientDTO patient) {
		Precondition.assertNotNull("patient", patient);
		return CORRELATED.equals(patient.getCorrelationStatus());
	}

	public static boolean isPendingCorrelation(PatientDTO patient) {
		Precondition.assertNotNull("patient", patient);
		return PENDINGCORRELATION.equals(patient.getCorrelationStatus());
	}

	public static boolean isPendingUncorrelation(PatientDTO patient) {
		Precondition.assertNotNull("patient", patient);
		return PENDINGUNCORRELATION.equals(patient.getCorrelationStatus());
	}

	public static boolean isFailedCorrelation(PatientDTO patient) {
		Precondition.assertNotNull("patient", patient);
		return FAILEDCORRELATION.equals(patient.getCorrelationStatus());
	}

	public static boolean isFailedUncorrelation(PatientDTO patient) {
		Precondition.assertNotNull("patient", patient);
		return FAILEDUNCORRELATION.equals(patient.getCorrelationStatus());
	}

	public static boolean isCorrelationInvalid(PatientDTO patient) {
		Precondition.assertNotNull("patient", patient);
		return CORRELATIONINVALID.equals(patient.getCorrelationStatus());
	}

	public static boolean isMviDataMatch(PatientDTO patient) {
		Precondition.assertNotNull("patient", patient);
		return MVIDATAMATCH.equals(patient.getCorrelationStatus());
	}

}
